# اتصال مشاوره هوشمند به Backend (راه حل امنیتی)

## مشکل
OpenAI SDK در frontend خطای امنیتی می‌دهد چون API Key در مرورگر در معرض خطر است.

## راه حل
✅ انتقال تمام API calls به backend

## تغییرات انجام شده

### 1. Backend Endpoint (`backend/routes.js`)
```javascript
router.post('/ai/generate-plan', sanitizeBody, async (req, res) => {
  // ✅ دریافت ایده از frontend
  // ✅ خواندن API Key از settings در دیتابیس
  // ✅ اتصال به Liara AI از backend
  // ✅ برگرداندن پاسخ به frontend
});
```

### 2. Frontend Service (`services/geminiService.ts`)
```typescript
// ✅ استفاده از backend API به جای مستقیم OpenAI
const response = await DataService.apiClient('/ai/generate-plan', 'POST', {
  idea: userIdea,
  customInstruction: customInstruction
});
```

### 3. Export apiClient (`services/dataService.ts`)
```typescript
export const DataService = {
  // ...
  apiClient: apiClient,  // ✅ برای استفاده در سایر سرویس‌ها
};
```

### 4. نصب OpenAI SDK در Backend
```json
// backend/package.json
"openai": "^4.20.0"
```

## جریان کار

1. **Frontend**: کاربر ایده را وارد می‌کند
2. **Frontend**: درخواست به `/api/ai/generate-plan` ارسال می‌شود
3. **Backend**: API Key از settings در دیتابیس خوانده می‌شود
4. **Backend**: درخواست به Liara AI ارسال می‌شود
5. **Backend**: پاسخ از Liara AI دریافت می‌شود
6. **Backend**: پاسخ به frontend برگردانده می‌شود
7. **Frontend**: نتیجه نمایش داده می‌شود

## مزایا

✅ **امنیت**: API Key در backend نگهداری می‌شود
✅ **کنترل**: تمام درخواست‌های AI از backend مدیریت می‌شوند
✅ **Rate Limiting**: می‌توان rate limiting اضافه کرد
✅ **Logging**: تمام درخواست‌ها در backend لاگ می‌شوند
✅ **هیچ API Key در frontend نیست**

## نتیجه

✅ مشکل امنیتی برطرف شد
✅ API Key در backend محفوظ است
✅ مشاوره هوشمند از طریق backend کار می‌کند
✅ آماده برای استفاده در production

