# رفع خطای 500 در AI Endpoint

## مشکل
```
Failed to load resource: the server responded with a status of 500
API Error: Error: Error 500
```

## علت احتمالی
1. پکیج `openai` در backend نصب نشده
2. خطا در ارتباط با Liara AI
3. خطا در parse کردن JSON response
4. ساختار پاسخ AI معتبر نیست

## راه حل

### 1. بهبود Error Handling
- ✅ بررسی نصب بودن پکیج `openai`
- ✅ Catch کردن خطاهای OpenAI API
- ✅ بررسی و parse کردن JSON response
- ✅ Validate کردن ساختار پاسخ

### 2. به‌روزرسانی Default Model
- ✅ تغییر از `google/gemini-2.0-flash-001` به `openai/gpt-4o-mini`
- ✅ به‌روزرسانی در default settings

### 3. بهبود Logging
- ✅ لاگ کردن خطاهای دقیق
- ✅ لاگ کردن model و baseURL
- ✅ لاگ کردن محتوای پاسخ در صورت خطا

## تغییرات انجام شده

### `backend/routes.js`

1. **بررسی نصب بودن پکیج:**
```javascript
let OpenAI;
try {
  OpenAI = require('openai');
} catch (requireError) {
  return res.status(500).json({ 
    message: 'پکیج OpenAI نصب نشده است...' 
  });
}
```

2. **بهبود Error Handling:**
```javascript
try {
  completion = await openai.chat.completions.create({...});
} catch (openaiError) {
  logger.error('OpenAI API call error', {...});
  return res.status(500).json({ message: '...' });
}
```

3. **Validate کردن JSON:**
```javascript
try {
  parsed = JSON.parse(content);
} catch (parseError) {
  return res.status(500).json({ message: '...' });
}
```

4. **Validate کردن ساختار:**
```javascript
if (!parsed.techStack || !parsed.roadmap || !parsed.summary) {
  return res.status(500).json({ message: '...' });
}
```

5. **به‌روزرسانی Default Model:**
```javascript
const modelName = settings?.aiConfig?.modelName || 'openai/gpt-4o-mini';
```

## اقدامات لازم

### 1. نصب پکیج OpenAI در Backend
```bash
cd backend
npm install openai
```

### 2. بررسی تنظیمات
- ✅ API Key در پنل ادمین وارد شده باشد
- ✅ Model Name: `openai/gpt-4o-mini`
- ✅ مشاوره هوشمند فعال باشد

### 3. بررسی لاگ‌ها
بعد از تست، لاگ‌های backend را بررسی کنید تا خطای دقیق مشخص شود.

## نتیجه

✅ Error handling بهبود یافت
✅ Default model به GPT-4o-mini تغییر کرد
✅ لاگ‌های دقیق‌تر اضافه شد
✅ Validate کردن پاسخ اضافه شد

## نکته مهم

اگر هنوز خطا می‌دهد، لاگ‌های backend را بررسی کنید تا خطای دقیق مشخص شود.

