# رفع مشکل امنیتی OpenAI SDK

## مشکل
```
It looks like you're running in a browser-like environment. This is disabled by default, as it risks exposing your secret API credentials to attackers.
```

## علت
OpenAI SDK به صورت پیش‌فرض اجازه استفاده در مرورگر را نمی‌دهد چون API Key در frontend در معرض خطر است.

## راه حل
✅ انتقال API calls به backend برای حفظ امنیت API Key

## تغییرات انجام شده

### 1. Backend Endpoint (`backend/routes.js`)
```javascript
router.post('/ai/generate-plan', sanitizeBody, async (req, res) => {
  // دریافت ایده از frontend
  // خواندن API Key از settings در دیتابیس
  // اتصال به Liara AI از backend
  // برگرداندن پاسخ به frontend
});
```

### 2. Frontend Service (`services/geminiService.ts`)
```typescript
// قبل: مستقیماً OpenAI را در frontend صدا می‌زد
const openai = new OpenAI({ apiKey, baseURL });

// بعد: از backend API استفاده می‌کند
const response = await DataService.apiClient('/ai/generate-plan', 'POST', {
  idea: userIdea,
  customInstruction: customInstruction
});
```

### 3. نصب OpenAI SDK در Backend
```json
// backend/package.json
"openai": "^4.20.0"
```

## مزایا

✅ **امنیت**: API Key در backend نگهداری می‌شود و در frontend در معرض خطر نیست
✅ **کنترل**: تمام درخواست‌های AI از backend مدیریت می‌شوند
✅ **Rate Limiting**: می‌توان rate limiting اضافه کرد
✅ **Logging**: تمام درخواست‌ها در backend لاگ می‌شوند

## جریان کار

1. **Frontend**: کاربر ایده را وارد می‌کند
2. **Frontend**: درخواست به `/api/ai/generate-plan` ارسال می‌شود
3. **Backend**: API Key از settings در دیتابیس خوانده می‌شود
4. **Backend**: درخواست به Liara AI ارسال می‌شود
5. **Backend**: پاسخ از Liara AI دریافت می‌شود
6. **Backend**: پاسخ به frontend برگردانده می‌شود
7. **Frontend**: نتیجه نمایش داده می‌شود

## نتیجه

✅ مشکل امنیتی برطرف شد
✅ API Key در backend محفوظ است
✅ مشاوره هوشمند از طریق backend کار می‌کند
✅ هیچ API Key در frontend در معرض خطر نیست

