# اتصال مشاوره هوشمند به Liara AI

## تغییرات انجام شده

### 1. نصب OpenAI SDK
```json
"openai": "^4.20.0"
```

### 2. تغییر `services/geminiService.ts`
- ✅ جایگزینی `@google/genai` با `openai` SDK
- ✅ استفاده از `baseURL` و `apiKey` از تنظیمات
- ✅ استفاده از مدل `google/gemini-2.0-flash-001`
- ✅ استفاده از `response_format: { type: "json_object" }`

### 3. تنظیمات Liara AI
```typescript
const baseURL = 'https://ai.liara.ir/api/69492c43a99a2016cacea976/v1';
const modelName = 'google/gemini-2.0-flash-001';
```

### 4. به‌روزرسانی پنل ادمین
- ✅ تغییر placeholder به "کلید API Liara AI را وارد کنید"
- ✅ اضافه کردن label و راهنما
- ✅ تغییر متن badge در AIPlanner به "قدرت گرفته از Liara AI"

### 5. به‌روزرسانی Default Settings
- ✅ `provider: 'liara'`
- ✅ `modelName: 'google/gemini-2.0-flash-001'`
- ✅ `apiKey: ''` (باید از پنل ادمین وارد شود)

## نحوه استفاده

### 1. دریافت API Key از Liara
1. وارد پنل Liara شوید
2. به بخش AI بروید
3. API Key را کپی کنید

### 2. تنظیم در پنل ادمین
1. وارد پنل ادمین شوید
2. به بخش "تنظیمات" بروید
3. در بخش "تنظیمات هوش مصنوعی":
   - ✅ "فعال‌سازی دستیار هوشمند" را فعال کنید
   - ✅ API Key Liara را وارد کنید
   - ✅ System Prompt را تنظیم کنید (اختیاری)
4. روی "ذخیره تمام تنظیمات" کلیک کنید

### 3. تست
1. به صفحه اصلی بروید
2. به بخش "مشاوره هوشمند" بروید
3. یک ایده پروژه وارد کنید
4. روی "تحلیل ایده" کلیک کنید

## ساختار کد

### `services/geminiService.ts`
```typescript
import OpenAI from "openai";

const openai = new OpenAI({
  baseURL: 'https://ai.liara.ir/api/69492c43a99a2016cacea976/v1',
  apiKey: settings?.aiConfig?.apiKey,
});

const completion = await openai.chat.completions.create({
  model: 'google/gemini-2.0-flash-001',
  messages: [...],
  response_format: { type: "json_object" },
});
```

## نکات مهم

1. ✅ API Key در تنظیمات پنل ادمین ذخیره می‌شود
2. ✅ Base URL و Model ID ثابت هستند (از Liara)
3. ✅ System Prompt قابل تنظیم است
4. ✅ پاسخ به صورت JSON برمی‌گردد

## نتیجه

✅ مشاوره هوشمند به Liara AI متصل شد
✅ API Key از پنل ادمین قابل تنظیم است
✅ استفاده از OpenAI SDK (سازگار با Liara)
✅ تمام تنظیمات در دیتابیس ذخیره می‌شود

