# راهنمای کامل نصب و راه‌اندازی در لیارا

## 📋 پیش‌نیازها

1. ✅ اکانت لیارا
2. ✅ یک دیتابیس MySQL در لیارا
3. ✅ Node.js 18 یا بالاتر (در لیارا خودکار است)

---

## 🚀 مراحل نصب

### مرحله 1: ایجاد دیتابیس MySQL در لیارا

1. وارد پنل لیارا شوید: https://console.liara.ir
2. به بخش **Databases** بروید
3. روی **Create Database** کلیک کنید
4. نوع دیتابیس را **MySQL** انتخاب کنید
5. یک نام برای دیتابیس انتخاب کنید (مثلاً: `viraving_db`)
6. پس از ایجاد، اطلاعات اتصال را یادداشت کنید:
   - **Host**: `xxxxx.liara.cloud`
   - **Port**: `3306`
   - **Username**: معمولاً `root`
   - **Password**: رمز عبور دیتابیس
   - **Database Name**: نام دیتابیس

### مرحله 2: ایجاد اپلیکیشن Node.js در لیارا

1. به بخش **Apps** بروید
2. روی **Create App** کلیک کنید
3. نام اپلیکیشن را وارد کنید (مثلاً: `viraving-web`)
4. Platform را **Node.js** انتخاب کنید
5. روی **Create** کلیک کنید

### مرحله 3: تنظیم متغیرهای محیطی

در پنل لیارا، به بخش **Environment Variables** اپلیکیشن بروید و متغیرهای زیر را اضافه کنید:

```env
# Database Configuration
DB_HOST=your-mysql-host.liara.cloud
DB_PORT=3306
DB_USER=root
DB_PASSWORD=your-mysql-password
DB_NAME=your-database-name

# JWT Secret (یک رشته تصادفی و امن ایجاد کنید)
JWT_SECRET=your-super-secret-jwt-key-min-32-characters-long

# Gemini AI API Key (از Google AI Studio دریافت کنید)
GEMINI_API_KEY=your-gemini-api-key

# Frontend Environment (برای Vite)
VITE_GEMINI_API_KEY=your-gemini-api-key

# Server Port (معمولاً لیارا خودکار تنظیم می‌کند)
PORT=3001

# Node Environment
NODE_ENV=production
```

**⚠️ نکته مهم**: 
- `JWT_SECRET` باید یک رشته تصادفی و امن باشد (حداقل 32 کاراکتر)
- می‌توانید از این دستور برای تولید یک JWT_SECRET استفاده کنید:
  ```bash
  node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"
  ```

### مرحله 4: اتصال دیتابیس به اپلیکیشن

1. در پنل لیارا، به بخش **Connections** اپلیکیشن بروید
2. دیتابیس MySQL خود را به اپلیکیشن متصل کنید
3. این کار باعث می‌شود که متغیرهای محیطی دیتابیس به صورت خودکار تنظیم شوند

### مرحله 5: آپلود پروژه

#### روش 1: استفاده از Git (پیشنهادی)

1. پروژه را در یک repository (مثلاً GitHub) push کنید
2. در پنل لیارا، به بخش **Deploy** بروید
3. **Source** را **Git** انتخاب کنید
4. Repository خود را متصل کنید
5. Branch را `main` یا `master` انتخاب کنید
6. روی **Deploy** کلیک کنید

#### روش 2: استفاده از Liara CLI

```bash
# نصب Liara CLI (اگر نصب نشده)
npm install -g @liara/cli

# لاگین به لیارا
liara login

# در مسیر پروژه
cd /path/to/viraving-web

# آپلود پروژه
liara deploy --app viraving-web --platform node
```

### مرحله 6: تنظیم Build و Start Commands

در پنل لیارا، به بخش **Settings** > **Build & Deploy** بروید:

**Build Command:**
```bash
npm install && npm run build
```

**Start Command:**
```bash
cd backend && npm install && npm start
```

**⚠️ توجه**: لیارا به صورت خودکار `liara.json` را می‌خواند، اما می‌توانید این دستورات را در پنل هم تنظیم کنید.

### مرحله 7: نصب اولیه (First Time Setup)

پس از deploy موفق، به آدرس سایت خود بروید. صفحه نصب‌کننده نمایش داده می‌شود:

1. **مرحله 1: اتصال به دیتابیس**
   - اطلاعات دیتابیس MySQL لیارا را وارد کنید
   - اگر در مرحله 3 متغیرهای محیطی را تنظیم کرده‌اید، این اطلاعات باید به صورت خودکار پر شده باشند
   - روی **مرحله بعد** کلیک کنید

2. **مرحله 2: ایجاد مدیر کل**
   - نام کاربری مدیر را وارد کنید (مثلاً: `admin`)
   - ایمیل مدیر را وارد کنید
   - رمز عبور قوی انتخاب کنید
   - روی **پایان نصب و ورود** کلیک کنید

3. **پایان نصب**
   - پس از نصب موفق، به صورت خودکار به پنل مدیریت منتقل می‌شوید
   - آدرس پنل مدیریت: `https://your-domain.com/#admin`

---

## 🔧 تنظیمات اضافی

### تنظیم Domain

1. در پنل لیارا، به بخش **Domains** بروید
2. دامنه خود را اضافه کنید
3. DNS records را طبق راهنمای لیارا تنظیم کنید

### تنظیم SSL

لیارا به صورت خودکار SSL رایگان (Let's Encrypt) برای دامنه‌های متصل شده فعال می‌کند.

### تنظیم Storage برای فایل‌های آپلود شده

فایل‌های آپلود شده در `backend/public/uploads` ذخیره می‌شوند. برای production بهتر است از Object Storage لیارا استفاده کنید.

---

## 📝 ساختار پروژه

```
viraving-web/
├── backend/              # سرور Node.js/Express
│   ├── db.js            # اتصال به MySQL
│   ├── routes.js        # API Routes
│   ├── server.js        # سرور اصلی
│   └── public/          # فایل‌های استاتیک
│       └── uploads/     # فایل‌های آپلود شده
├── src/                 # Frontend React
│   ├── App.tsx
│   └── main.tsx
├── components/          # کامپوننت‌های React
├── services/            # سرویس‌های Frontend
├── dist/                # Build output (تولید می‌شود)
├── liara.json           # تنظیمات لیارا
└── package.json         # Dependencies
```

---

## 🔒 نکات امنیتی

1. ✅ **JWT_SECRET**: حتماً یک مقدار امن و تصادفی استفاده کنید
2. ✅ **Database Password**: رمز عبور قوی برای دیتابیس انتخاب کنید
3. ✅ **API Keys**: کلیدهای API را در Environment Variables نگه دارید، نه در کد
4. ✅ **HTTPS**: همیشه از HTTPS استفاده کنید (لیارا خودکار فعال می‌کند)

---

## 🐛 عیب‌یابی

### مشکل اتصال به دیتابیس

- ✅ بررسی کنید که متغیرهای محیطی (`DB_HOST`, `DB_USER`, `DB_PASSWORD`, `DB_NAME`) به درستی تنظیم شده‌اند
- ✅ اطمینان حاصل کنید که دیتابیس به اپلیکیشن متصل شده است
- ✅ لاگ‌های سرور را در پنل لیارا بررسی کنید

### مشکل در Build

- ✅ بررسی کنید که `Node.js` version 18 یا بالاتر است
- ✅ لاگ‌های build را در پنل لیارا بررسی کنید
- ✅ مطمئن شوید که همه dependencies در `package.json` تعریف شده‌اند

### مشکل در نصب اولیه

- ✅ لاگ‌های سرور را در پنل لیارا بررسی کنید
- ✅ اطمینان حاصل کنید که دیتابیس خالی است و جداول قبلی وجود ندارند
- ✅ بررسی کنید که جداول به درستی ایجاد شده‌اند

### مشکل در API

- ✅ بررسی کنید که `JWT_SECRET` تنظیم شده است
- ✅ بررسی کنید که `GEMINI_API_KEY` و `VITE_GEMINI_API_KEY` تنظیم شده‌اند
- ✅ لاگ‌های سرور را بررسی کنید

---

## 📞 پشتیبانی

برای مشکلات بیشتر:
1. لاگ‌های سرور را در پنل لیارا بررسی کنید
2. مستندات لیارا را مطالعه کنید: https://doc.liara.ir
3. با پشتیبانی لیارا تماس بگیرید

---

## ✅ چک‌لیست نهایی

قبل از deploy، مطمئن شوید:

- [ ] دیتابیس MySQL در لیارا ایجاد شده است
- [ ] متغیرهای محیطی تنظیم شده‌اند
- [ ] `JWT_SECRET` یک مقدار امن است
- [ ] `GEMINI_API_KEY` و `VITE_GEMINI_API_KEY` تنظیم شده‌اند
- [ ] دیتابیس به اپلیکیشن متصل شده است
- [ ] Build command درست تنظیم شده است
- [ ] Start command درست تنظیم شده است
- [ ] Domain (در صورت نیاز) تنظیم شده است

---

**موفق باشید! 🎉**

