# اصلاح Model Name - اضافه کردن :online suffix

## ❌ مشکل

خطای 400 از Liara AI:
```
"model" must be one of [...]
```

مدل `openai/gpt-5-mini` در لیست مدل‌های معتبر نیست!

## ✅ راه‌حل

در لیست مدل‌های معتبر، مدل‌ها با suffix `:online` هستند:
- ✅ `openai/gpt-5-mini:online` - معتبر
- ❌ `openai/gpt-5-mini` - نامعتبر

## 🔧 تغییرات انجام شده

### 1. backend/routes.js
- ✅ خط 710: `'openai/gpt-5-mini'` → `'openai/gpt-5-mini:online'`
- ✅ خط 588: `'openai/gpt-5-mini'` → `'openai/gpt-5-mini:online'`
- ✅ خط 936: `'openai/gpt-5-mini'` → `'openai/gpt-5-mini:online'`

### 2. services/dataService.ts
- ✅ خط 160: `'openai/gpt-5-mini'` → `'openai/gpt-5-mini:online'`

### 3. components/AdminPanel.tsx
- ✅ Placeholder: `'openai/gpt-5-mini'` → `'openai/gpt-5-mini:online'`
- ✅ مثال: `'google/gemini-2.5-flash'` → `'google/gemini-2.5-flash:online'`

## 📝 مدل‌های معتبر (از لیست خطا)

### OpenAI Models:
- `openai/gpt-5.1`
- `openai/gpt-5.1:online`
- `openai/gpt-5.1-chat`
- `openai/gpt-5.1-chat:online`
- `openai/gpt-5-mini:online` ✅ (پیش‌فرض)
- `openai/gpt-5-nano:online`
- `openai/gpt-5-chat:online`
- `openai/gpt-5:online`
- `openai/gpt-4o-mini:online`

### Google Gemini Models:
- `google/gemini-2.5-flash:online` ✅
- `google/gemini-2.5-pro:online`
- `google/gemini-2.0-flash-001:online`

### نکته مهم:
همه مدل‌ها باید suffix `:online` داشته باشند (یا بدون suffix برای مدل‌های خاص).

## ✅ نتیجه

همه default model names به `openai/gpt-5-mini:online` تغییر کرده‌اند.

اگر کاربر می‌خواهد از Gemini استفاده کند، باید `google/gemini-2.5-flash:online` را در AdminPanel تنظیم کند.

