# رفع مشکل حرکت باکس‌های خدمات در موبایل

## مشکل
در موبایل وقتی روی باکس خدمات کلیک می‌شود، باکس حالت حرکتی دارد و به سمت بالا می‌رود و کمی زیر باکس مادرش می‌رود و نمایش داده نمی‌شود.

## علت
استفاده از `hover:-translate-y-1` که در موبایل بعد از کلیک فعال می‌ماند و باعث حرکت باکس می‌شود.

## راه حل

### تغییرات انجام شده:

1. **محدود کردن translate به desktop:**
   - قبل: `hover:-translate-y-1` (در همه دستگاه‌ها)
   - بعد: `md:hover:-translate-y-1` (فقط در desktop)

2. **اضافه کردن active state برای موبایل:**
   - `active:scale-[0.98]` - در موبایل هنگام کلیک کمی کوچک می‌شود
   - `md:active:scale-100` - در desktop active state ندارد

3. **افزایش padding-bottom:**
   - قبل: `pb-8`
   - بعد: `pb-12` - فضای بیشتر برای جلوگیری از مخفی شدن

## نتیجه

✅ در موبایل باکس دیگر به سمت بالا حرکت نمی‌کند
✅ در موبایل هنگام کلیک فقط کمی کوچک می‌شود (feedback بصری)
✅ در desktop hover effect حفظ شده است
✅ فضای کافی برای نمایش باکس‌ها وجود دارد

## تغییرات

### `components/Services.tsx`

```tsx
// قبل:
className="... hover:-translate-y-1 ..."
<div className="... pb-8 ...">

// بعد:
className="... md:hover:-translate-y-1 active:scale-[0.98] md:active:scale-100 ..."
<div className="... pb-12 ...">
```

