import React, { useEffect } from 'react';
import Hero from './Hero';
import Services from './Services';
import Process from './Process';
import Team from './Team';
import Blog from './Blog';
import Reviews from './Reviews';
import AIPlanner from './AIPlanner';
import Reveal from './Reveal';

const HomeView: React.FC = () => {
  
  useEffect(() => {
    const handleScroll = () => {
      // Small timeout to ensure DOM is ready if coming from another page
      setTimeout(() => {
        const params = new URLSearchParams(window.location.hash.split('?')[1]);
        const scrollTarget = params.get('scroll');
        if (scrollTarget) {
          const element = document.getElementById(scrollTarget);
          if (element) {
             element.scrollIntoView({ behavior: 'smooth' });
          }
        }
      }, 100);
    };

    // Check on mount
    handleScroll();

    // Check on hash change (for when already on HomeView)
    window.addEventListener('hashchange', handleScroll);
    return () => window.removeEventListener('hashchange', handleScroll);
  }, []);

  const handleNavClick = (e: React.MouseEvent<HTMLAnchorElement>, target: string) => {
    e.preventDefault();
    window.location.hash = target;
  };

  return (
    <div className="overflow-hidden"> {/* Prevent horizontal overflow from animations */}
      <Hero />
      
      <Reveal direction="up" delay={0.2}>
        <Services />
      </Reveal>
      
      <Reveal direction="up">
        <Process />
      </Reveal>
      
      <Reveal width="100%" direction="up">
        <div className="bg-white dark:bg-slate-900 py-16 text-center transition-colors duration-300">
          <div className="container mx-auto px-4">
              <h2 className="text-3xl font-bold text-slate-900 dark:text-white mb-6">پروژه‌های ما را دیده‌اید؟</h2>
              <p className="text-slate-600 dark:text-slate-400 mb-8 max-w-2xl mx-auto">برای مشاهده نمونه‌کارهای اخیر و آشنایی با کیفیت کار تیم ویراوینگ، به بخش نمونه‌کارها مراجعه کنید.</p>
              <a 
                href="#portfolio" 
                onClick={(e) => handleNavClick(e, '#portfolio')}
                className="inline-block bg-slate-100 dark:bg-slate-800 text-slate-900 dark:text-white px-8 py-3 rounded-xl border border-slate-200 dark:border-slate-700 hover:bg-indigo-600 hover:text-white dark:hover:bg-indigo-600 transition-all cursor-pointer shadow-sm hover:shadow-lg"
              >
                مشاهده نمونه‌کارها
              </a>
          </div>
        </div>
      </Reveal>

      <AIPlanner />
      
      <Reveal direction="right">
        <Team />
      </Reveal>
      
      <Reveal direction="left">
        <Blog />
      </Reveal>
      
      <Reveal direction="up">
        <Reviews />
      </Reveal>
    </div>
  );
};

export default HomeView;