import React, { useEffect, useState } from 'react';
import { ArrowRight, ShieldCheck, FileText } from 'lucide-react';
import { DataService } from '../services/dataService';

interface LegalPageProps {
  type: 'terms' | 'privacy';
}

const LegalPage: React.FC<LegalPageProps> = ({ type }) => {
  const [content, setContent] = useState('');
  const [title, setTitle] = useState('');

  useEffect(() => {
    const fetchData = async () => {
      const settings = await DataService.getSettings();
      if (settings?.legal) {
        if (type === 'terms') {
          setContent(settings.legal.terms || '<p>محتوایی یافت نشد.</p>');
          setTitle('قوانین و مقررات');
        } else {
          setContent(settings.legal.privacy || '<p>محتوایی یافت نشد.</p>');
          setTitle('حریم خصوصی');
        }
      }
    };
    fetchData();
    window.scrollTo(0, 0);
  }, [type]);

  const handleNavClick = (e: React.MouseEvent<HTMLAnchorElement>, target: string) => {
    e.preventDefault();
    window.location.hash = target;
  };

  return (
    <section className="min-h-screen pt-24 md:pt-32 pb-24 bg-slate-50 dark:bg-slate-950 transition-colors duration-300">
      <div className="container mx-auto px-4 max-w-4xl">
        
        <div className="mb-8">
          <a href="#home" onClick={(e) => handleNavClick(e, '#home')} className="inline-flex items-center gap-2 text-slate-500 hover:text-indigo-600 transition-colors mb-6">
            <ArrowRight size={18} /> بازگشت به صفحه اصلی
          </a>
          
          <div className="flex items-center gap-4 mb-6">
            <div className="w-12 h-12 bg-indigo-100 dark:bg-indigo-900/30 text-indigo-600 dark:text-indigo-400 rounded-xl flex items-center justify-center">
               {type === 'terms' ? <FileText size={24} /> : <ShieldCheck size={24} />}
            </div>
            <h1 className="text-3xl md:text-4xl font-bold text-slate-900 dark:text-white">{title}</h1>
          </div>
        </div>

        <div className="bg-white dark:bg-slate-900 rounded-3xl p-8 md:p-12 border border-slate-200 dark:border-slate-800 shadow-xl">
           <div 
             className="prose prose-lg dark:prose-invert max-w-none prose-headings:font-bold prose-headings:text-slate-900 dark:prose-headings:text-white prose-p:text-slate-600 dark:prose-p:text-slate-300 prose-a:text-indigo-600 dark:prose-a:text-indigo-400 prose-ul:list-disc prose-ol:list-decimal"
             dangerouslySetInnerHTML={{ __html: content }} 
           />
        </div>

      </div>
    </section>
  );
};

export default LegalPage;