import { AIPlanResponse } from "../types";
import { DataService } from "./dataService";

export const generateProjectPlan = async (userIdea: string, customInstruction?: string): Promise<AIPlanResponse> => {
  // Call backend API instead of directly calling OpenAI
  // This keeps API key secure on the server
  const useApi = DataService.getApiMode();
  
  if (useApi) {
    try {
      const response = await DataService.apiClient('/ai/generate-plan', 'POST', {
        idea: userIdea,
        customInstruction: customInstruction
      });
      return response as AIPlanResponse;
    } catch (error: any) {
      throw new Error(error.message || 'خطا در ارتباط با هوش مصنوعی.');
    }
  } else {
    // Fallback for local development (if needed)
    throw new Error('برای استفاده از مشاوره هوشمند، باید به backend متصل باشید.');
  }
};